/*
 * Copyright (C) 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored-by: Florian Boucault <florian.boucault@canonical.com>
 */
import QtQuick 2.4
import Lomiri.Components

ShaderEffect {
    id: tabContour

    property Image source: Image {
        width: tabContour.width
        height: tabContour.height
        source: "tab_contour@24.png"
        scale: units.gridUnit / 24
        fillMode: Image.Pad
        horizontalAlignment: Image.AlignLeft
        verticalAlignment: Image.AlignTop
        visible: false
        cache: true
        asynchronous: true
    }

    property color backgroundColor
    property color contourColor
    property color outsideColor
    property real sourceWidth: source.paintedWidth / tabContour.width
    property real sourceHeight: source.paintedHeight / tabContour.height

    fragmentShader: "qrc:/shaders/tabsbar/tab-contour.frag.qsb"
}
