/*
 * Copyright 2012-2016 Canonical Ltd.
 *
 * This file is part of lomiri-messaging-app.
 *
 * lomiri-messaging-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * dialer-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtQuick.Layouts 1.1
import Qt.labs.settings 1.0

import Lomiri.Components 1.3
import Lomiri.Contacts 0.1


Loader {
    id: root

    property bool necessary: true
    property bool demoForPinchZoomNeeded: true
    property bool enabled: false
    property string currentDemo: ""

    function enable() {
        root.enabled = true;
        if (necessary) {
            selectDemo("ListItemDemo.qml")
        } else if (demoForPinchZoomNeeded) {
            selectDemo("PinchToZoomDemo.qml")
        }
    }

    function disable() {
        if (root.enabled) {
            if (root.currentDemo == "ListItemDemo.qml") {
                root.necessary = false;
            } else if (root.currentDemo == "PinchToZoomDemo.qml") {
                root.demoForPinchZoomNeeded = false;
            }

            root.enabled = false;
            root.source = "";
            pageHeader.visible = true;
        }
    }

    function selectDemo(name) {
       currentDemo = name
       runTimer.start()
    }

    asynchronous: true

    Binding {
        target: root.item
        property: "enabled"
        value: root.enabled
    }

    Connections {
        target: root.item
        function onDisable() { root.disable() }
    }

    Timer {
        id: runTimer

        running: false
        interval: 2000
        repeat: false
        onTriggered: root.source = Qt.resolvedUrl(root.currentDemo)

    }

    Settings {
        property alias hintNecessary: root.necessary
        property alias demoForPinchZoomNeeded: root.demoForPinchZoomNeeded
    }
}
