/*
 * Copyright 2025 UBports Foundation
 *
 * This file is part of messaging-app.
 *
 * messaging-app is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * messaging-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.9
import Lomiri.Components 1.3
import Lomiri.Components.Popups 1.3

Dialog {
    id: noNetworkDialog

    title: i18n.tr("MMS connectivity")
    text: i18n.tr("To send or receive MMS, turn off Wi-Fi and turn on mobile data.")
    Button {
        text: i18n.tr("Close")
        onClicked: {
            PopupUtils.close(noNetworkDialog)
            Qt.inputMethod.hide()
        }
    }
}
